#!/usr/bin/env python
# -*- coding: utf-8 -*-

# ###########################################################
# Minimal-Demonstrator für die OSMscr2-Klasse.
#
# Detlev Ahlgrimm, 2017


import wx               # python-wxWidgets-2.8.12.1-10.4.1.x86_64
import os
from OSMscr2 import OSMscr2

VERSION="1.0"

HOME_DIR=os.path.expanduser('~')
SOURCE={
  "OSM"   : { "tile_url"  : "http://tile.openstreetmap.org/{z}/{x}/{y}.png",
              "tile_size" : 256,
              "max_zoom"  : 19,
              "cache_dir" : os.path.join(HOME_DIR, "wd", "osm")
            }}
SERVER="OSM"

class MapWindow(wx.Window):
  def __init__(self, parent, centerLL, zoom, border, title, size):
    wx.Window.__init__(self, parent)
    self.parent=parent
    self.centerLL=centerLL
    self.zoom=zoom
    self.border=border
    self.Bind(wx.EVT_PAINT,         self.onPaint)
    self.Bind(wx.EVT_LEFT_DOWN,     self.onLeftDown)
    self.Bind(wx.EVT_LEFT_UP,       self.onLeftUp)
    self.Bind(wx.EVT_MOTION,        self.onMotion)
    self.Bind(wx.EVT_MOUSEWHEEL,    self.onMouseWheel)
    self.Bind(wx.EVT_SIZE,          self.onSize)
    self.Bind(wx.EVT_TIMER,         self.onTimer)
    self.osm=OSMscr2(self.parent.GetSize(), SOURCE[SERVER], centerLL, self.zoom, self.border)
    self.timer_interval=100
    self.timer=wx.Timer(self)
    self.timer.Start(self.timer_interval)
    self.refresh_needed=False
    self.leftDown=False
    self.osm.loadPoints([(centerLL, 5,  wx.Brush("RED"), (1, " zentrum "))])
    self.osm.loadTracks([[(54.8050, 9.52445), (54.8054, 9.5244), (54.8057, 9.5245)]])

  def onPaint(self, evt):
    self.refresh_needed=self.osm.drawMap()
    dc=wx.PaintDC(self)
    imgbuf, (sx, sy)=self.osm.getBitmap()
    dc.DrawBitmap(imgbuf, sx, sy)

  def onLeftDown(self, evt):
    self.leftDown=True
    self.was_moved=False
    self.leftDownPosXY=evt.GetPosition()
    self.SetCursor(wx.StockCursor(wx.CURSOR_HAND))
    print "Klick:", self.osm.getLatLonForPixel(self.leftDownPosXY)

  def onLeftUp(self, evt):
    self.leftDown=False
    self.SetCursor(wx.StockCursor(wx.CURSOR_ARROW))
    if self.was_moved:
      self.osm.endMoveMap()
      self.Refresh()

  def onMotion(self, evt):
    data=self.osm.getDataForPoint(evt.GetPosition())      
    if len(data)>0: print data
    if self.leftDown:
      self.was_moved=True
      scroll_distXY=self.leftDownPosXY-evt.GetPosition()
      self.osm.doMoveMap(scroll_distXY)
      self.Refresh()

  def onMouseWheel(self, evt):
    zoom_old=self.zoom
    if evt.GetWheelRotation()>0:
      self.zoom=min(SOURCE[SERVER]["max_zoom"], self.zoom+1)
    else:
      self.zoom=max(0, self.zoom-1)
    if self.zoom!=zoom_old:
      self.osm.setZoom(self.zoom, evt.GetPosition())
      self.Refresh()

  def onSize(self, evt):
    try:
      self.osm.setSize(self.GetSize(), self.zoom, self.border)
    except:
      pass  # der allererste EVT_SIZE kommt, bevor self.osm existiert

  def onTimer(self, evt):
    if self.refresh_needed:
      self.Refresh()


class MapFrame(wx.Frame):
  def __init__(self, parent, centerLL, zoom, border, title, pos=wx.DefaultPosition, size=wx.DefaultSize):
    wx.Frame.__init__(self, None, wx.ID_ANY, title+" "+VERSION, pos=pos, size=size)
    win=MapWindow(self, centerLL, zoom, border, title, size)


if __name__=="__main__":
  app=wx.App(False)
  frame=MapFrame(None, (54.805060, 9.524878), 15, (2, 2), "OSMmini", size=(1024, 768))
  frame.Show()
  app.MainLoop()
