#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import os
import sys
import subprocess
import glob

KB=1024
MB=1024*KB

basisVerzeichnis              ="/1TB/test_genisoimage"
anzahlDateienImRoot           =500
byteProDatei                  =10
verlaengerungDateiname        ="a"*10
blockgroesse                  =2048


# ###########################################################
# Führt "cmd" aus und liefert dessen Rückgabe 
# bzw. "" bei Fehler.
def executeCmd(cmd):
  try:
    lns=subprocess.check_output(cmd, stderr=open(os.devnull, 'w'))
  except:
    return("")
  return(lns.strip())

# ###########################################################
# Erstellt eine Datei mit Größe="byteProDatei" und
# Dateinamen-Länge=6+"verlaengerungDateiname" im Verzeichnis
# "basisVerzeichnis".
def erstelleDateiIn(nummer, verzeichnis):
  dn="f%05i%s"%(nummer, verlaengerungDateiname)
  vdn=os.path.join(basisVerzeichnis, verzeichnis, dn)
  with open(vdn, "w") as fl:
    fl.write("*"*byteProDatei)

def erstelleVerzeichnis(nummer):
  vn="d%05i%s"%(nummer, verlaengerungDateiname)
  os.mkdir(os.path.join(basisVerzeichnis, vn))
  return(vn)


if __name__=="__main__":
  cmd=[
        ["genisoimage", "-print-size",                                      basisVerzeichnis],
        ["genisoimage", "-print-size", "-J",                                basisVerzeichnis],
        ["genisoimage", "-print-size", "-J", "-joliet-long",                basisVerzeichnis],
        ["genisoimage", "-print-size", "-r",                                basisVerzeichnis],
        ["genisoimage", "-print-size", "-r", "-J", "-joliet-long",          basisVerzeichnis],
        ["genisoimage", "-print-size", "-udf",                              basisVerzeichnis],
        ["genisoimage", "-print-size", "-r", "-J", "-joliet-long", "-udf",  basisVerzeichnis]
      ]
  lngs=[0, 10, 20, 30, 40, 75, 78, 79, 100, 200, 245] # werden mit +6 erstellt
  lngs=range(92, 100)
  lngs=[0]
  resu=[ [], [], [], [], [], [], [] ]

  for steps in range(len(lngs)):
    print "lng=", steps, lngs[steps]+6
    verlaengerungDateiname="a"*lngs[steps]

    files=glob.glob(os.path.join(basisVerzeichnis, "*"))
    for f in files:
      if os.path.isfile(f):
        os.remove(f)    # Dateien vom letzten Lauf löschen
      else:
        os.rmdir(f)

    dbs=[1, 1, 1, 1, 1, 2, 2]   # Dateien
#    dbs=[1, 2, 2, 1, 2, 3, 4]   # Verzeichnisse
    rca=[0, 0, 0, 0, 0, 0, 0]
    lst=[ [], [], [], [], [], [], [] ]
    for f in range(anzahlDateienImRoot):
      ol=[]
      for c in range(len(cmd)):
        n=executeCmd(cmd[c])
        ol.append(int(n)-int(rca[c]))
        rca[c]=n
      flg=""
      if f>0:
        for b in range(len(dbs)):
          if ol[b]!=dbs[b]:
            lst[b].append(str(f)+"+"+str(ol[b]-dbs[b]))
            flg+="<"+str(b)
      print "{0:4} {1:25}".format(f, rca), ol, flg

      erstelleDateiIn(f, "")
#      erstelleVerzeichnis(f)

    for i in range(len(cmd)):
      strg="%d %03d"%(i, 6+len(verlaengerungDateiname))
      for j in lst[i]:
        strg+=" "+j
      resu[i].append(strg)

  for i in range(len(resu)):
    for j in resu[i]:
      print j

