#!/usr/bin/env python
# -*- coding: utf-8 -*-

import wx
import globalStuff as glb

# ----------------------------------------------------------------------
#
class SetupColorFrame(wx.Frame):
    def __init__(self, parent, pos=wx.DefaultPosition, size=wx.DefaultSize):
        wx.Frame.__init__(self, None, pos=pos, size=size, title="Setup Colors")
        self.parent=parent
        self.Bind(wx.EVT_CLOSE, self.onClose)
        self.initUI()
        self.Show()

    # ------------------------------------------------------------------
    # onClose muss gefangen werden, um vorab die Bildschirmposition
    # und die Instanzvariable dieses Fensters im Hauptprogramm speichern
    # zu können.
    def onClose(self, event):
        self.parent.setupColDlgPos=self.GetScreenPosition()
        self.parent.setupColDlg=None
        self.Destroy()

    # ------------------------------------------------------------------
    # Liefert die aktuelle Bildschirmposition des Fensters zurück.
    def getPosition(self):
        return self.GetScreenPosition()

    # ------------------------------------------------------------------
    # Dialog aufbauen und darstellen.
    def initUI(self):
        self.panel=wx.Panel(self)

        self.cols=list()
        self.colPicker=list()
        for c_elem, c_color in sorted(glb.colors.items()):
            st=wx.StaticText(self.panel, wx.ID_ANY, " "+c_elem)
            self.cols.append(st)
            cp=wx.ColourPickerCtrl(self.panel, wx.ID_ANY, c_color)
            cp.Bind(wx.EVT_COLOURPICKER_CHANGED, self.colorChanged)
            self.colPicker.append(cp)
        rab=wx.Button(self.panel, wx.ID_ANY, " reset to defaults ")
        rab.Bind(wx.EVT_BUTTON, self.resetToDefaults)

        sizer=wx.GridBagSizer(1, 10)
        flag=wx.ALIGN_CENTER_VERTICAL
        for ci in range(len(glb.colors)):
            sizer.Add(self.cols[ci],      (ci, 0), flag=flag)
            sizer.Add(self.colPicker[ci], (ci, 1), flag=flag)
        sizer.Add(rab, (ci+1, 0), span=(1, 2), flag=wx.ALIGN_CENTER_HORIZONTAL)

        self.panel.SetFocus()
        self.panel.SetSizer(sizer)
        sizer.Fit(self)

    # ------------------------------------------------------------------
    # Wird bei Klick auf die "reset to defaults"-Schaltfläche aufgerufen
    # und stellt alle Farben auf den jeweiligen Defaultwert.
    def resetToDefaults(self, event):
        for i, (c_elem, c_color) in enumerate(sorted(glb.default_colors.items())):
            self.colPicker[i].SetColour(c_color)
            self.changeColor(i)
        self.parent.Refresh()

    # ------------------------------------------------------------------
    # Wird aufgerufen, wenn im ColourPickerCtrl die OK-Schaltfläche
    # gewählt wurde und übergibt die geänderte Farbe ans Hauptprogramm.
    def colorChanged(self, event):
        for i in range(len(self.colPicker)):
            if self.colPicker[i]==event.GetEventObject():
                self.changeColor(i)
        self.parent.Refresh()

    # ------------------------------------------------------------------
    # Übergibt die [geänderte] Farbe des Elementes mit dem Index idx
    # ans Hauptprogramm.
    def changeColor(self, idx):
        c_elem=self.cols[idx].GetLabel().strip()
        c_color=self.colPicker[idx].GetColour().GetAsString(wx.C2S_HTML_SYNTAX)
        glb.colors[c_elem]=c_color
