#!/usr/bin/env python
# -*- coding: utf-8 -*-


# ----------------------------------------------------------------------
#
class SelectedObjects():
    def __init__(self, tables, relations):
        self.tables=tables
        self.relations=relations
        self.clearAll()

    # ------------------------------------------------------------------
    # Löscht bzw. initialisiert die Menge der markierten Objekte.
    def clearAll(self):
        self.drag_start_mouse_pos=None
        self.obj={}                                                     # dict() mit set() als value
        self.base_pos={}                                                # dict() mit dict() als value

    # ------------------------------------------------------------------
    # Liefert True, wenn es markierte Objekte gibt.
    def hasElements(self):
        return len(self.obj)>0

    # ------------------------------------------------------------------
    # Überschreibt die Menge der markierten Objekte mit obj und data.
    # ...also bei sowas wie leftClick ohne Shift.
    def set(self, obj, data=None):
        self.obj={obj:{data}}

    # ------------------------------------------------------------------
    # Fügt das Objekt obj der Menge der markierten Objekte hinzu.
    def add(self, obj, data=None):
        if obj in self.obj:
            if data is not None:
                self.obj[obj].add(data)                                 # weiteren Eckpunkt zur bereits enthaltenen Relation zufügen
        else:
            self.obj.update({obj:{data}})                               # Eckpunkt oder Tabelle neu hinzufügen

    # ------------------------------------------------------------------
    # Fügt alle Eckpunkte gemäß data aus der Relation obj zur Menge der
    # markierten Objekte hinzu.
    # data enthält ein dict() mit den Index-Werten der Eckpunkte.
    def add_many(self, obj, data):
        self.obj.update({obj:data})

    # ------------------------------------------------------------------
    # Liefert True, wenn das Objekt obj zur Menge der markierten
    # Objekte gehört.
    # Wenn obj eine Tabelle ist, darf data nicht übergeben werden.
    # Wenn obj ein Eckpunkt ist, ist dessen Index in data zu übergeben.
    def find(self, obj, data=None):
        if obj in self.obj:
            if data is None:
                return True                                             # Tabelle gefunden
            elif data in self.obj[obj]:
                return True                                             # Eckpunkt gefunden
        return False

    # ------------------------------------------------------------------
    # Entfernt obj aus der Liste der markierten Objekte.
    # Wenn obj eine Tabelle ist, darf data nicht übergeben werden.
    # Wenn obj ein Eckpunkt ist, ist dessen Index in data zu übergeben.
    def remove(self, obj, data=None):
        if data is None:
            if obj in self.obj:
                self.obj.pop(obj)                                       # Tabelle aus der Menge der markierten Objekte löschen
        elif obj in self.obj:
            self.obj[obj].discard(data)                                 # Eckpunkt aus dem value-Set löschen
            if len(self.obj[obj])==0:                                   # wenn es dadurch leer geworden ist...
                self.obj.pop(obj)                                       # ...wird das gesamte Relations-Objekt aus der Menge der markierten Objekte entfernt

    # ------------------------------------------------------------------
    # Setzt die Start-Koordinate für die Move-Aktion und vermerkt die
    # derzeitigen Positionen aller vom Move betroffenen Objekte - um
    # während des Moves mit relativen Abständen zur ursprünglichen
    # Objekt-Position arbeiten zu können.
    def initMoveable(self, pos):
        self.drag_start_mouse_pos=pos
        if pos is None:
            self.base_pos={}
        else:
            for t in self.tables:
                if t in self.obj:
                    self.base_pos.update({t:t.pos})                     # ursprüngliche Tabellen-Positionen merken
            for r in self.relations:
                if r in self.obj:
                    self.base_pos[r]=dict()
                    for i in self.obj[r]:
                        if i<len(r.line):
                            self.base_pos[r].update({i:r.line[i]})      # ursprüngliche Eckpunkt-Positionen merken

    # ------------------------------------------------------------------
    # Liefert True, wenn es markierte Objekte gibt und eine
    # Start-Koordinate für die Move-Aktion gesetzt ist.
    def isReadyToBeMoved(self):
        return self.hasElements() and self.drag_start_mouse_pos is not None

