#!/usr/bin/env python
# -*- coding: utf-8 -*-

import copy
import globalStuff as glb

# ----------------------------------------------------------------------
# Nimmt die variablen Tabellen-Daten auf.
class ds_tab():
    def __init__(self, obj, pos):
        self.obj=obj
        self.pos=pos

# ----------------------------------------------------------------------
# Nimmt die variablen Relations-Daten auf.
class ds_rel():
    def __init__(self, obj, bdr_s, bdr_e, pos_lst):
        self.obj=obj
        self.bdr_s=bdr_s
        self.bdr_e=bdr_e
        self.pos_lst=pos_lst

# ----------------------------------------------------------------------
# Nimmt die variablen ERM-Daten auf.
class ds():
    def __init__(self):
        self.tabs=[]        # Liste aus ds_tab()'s
        self.rels=[]        # Liste aus ds_rel()'s

    def hasData(self):
        return len(self.tabs)>0 or len(self.rels)>0

# ----------------------------------------------------------------------
# 
class UndoHistory():
    def __init__(self, tables, relations):
        self.tables=tables
        self.relations=relations
        self.hist=[]                                                    # eine Liste aus Instanzen von ds()
        self.last_undo_point=None                                       # ds() - alle Positionen vor Eintritt in trackModifications()

    # ------------------------------------------------------------------
    # Setzt die Undo-Historie zurück.
    # Ist aufzurufen, wenn eine Datei neu geladen wird.
    def reset(self):
        self.hist=[]
        self.last_undo_point=None

    # ------------------------------------------------------------------
    # Speichert eine Kopie der derzeitigen Positionsdaten.
    # Ist bei MouseLeftDown aufzurufen.
    def prepare(self):
        self.last_undo_point=self.__getCurrentData()

    # ------------------------------------------------------------------
    # Liefert die Anzahl der zurücknehmbaren Änderungen.
    def length(self):
        return len(self.hist)

    # ------------------------------------------------------------------
    # Richtet alle Positionen gemäß new_raster neu aus.
    def changeRaster(self, new_raster):
        for i_h, d in enumerate(self.hist):
            for i_t, dt in enumerate(d.tabs):
                x=int(dt.pos[0]/float(glb.raster))*new_raster
                y=int(dt.pos[1]/float(glb.raster))*new_raster
                self.hist[i_h].tabs[i_t].pos=glb.pointOnNewRaster((x, y), new_raster)
            for i_r, dr in enumerate(d.rels):
                for i_p, p in enumerate(dr.pos_lst):
                    x=int(p[0]/float(glb.raster))*new_raster
                    y=int(p[1]/float(glb.raster))*new_raster
                    self.hist[i_h].rels[i_r].pos_lst[i_p]=glb.pointOnNewRaster((x, y), new_raster)

    # ------------------------------------------------------------------
    # Verschiebt alle Positionen um (dx, dy).
    def shiftBy(self, dx, dy):
        for i_h, d in enumerate(self.hist):
            for i_t, dt in enumerate(d.tabs):
                self.hist[i_h].tabs[i_t].pos=glb.pointOnRaster((dt.pos[0]+dx, dt.pos[1]+dy))
            for i_r, dr in enumerate(d.rels):
                for i_p, p in enumerate(dr.pos_lst):
                    self.hist[i_h].rels[i_r].pos_lst[i_p]=glb.pointOnRaster((p[0]+dx, p[1]+dy))

    # ------------------------------------------------------------------
    # Liefert eine Datenstruktur mit den Tabellen- und
    # Relations-Positionen.
    def __getCurrentData(self):
        d=ds()
        for t in self.tables:
            d.tabs.append(ds_tab(t, t.pos))
        for r in self.relations:
            d.rels.append(ds_rel(r, r.border_start, r.border_end, copy.copy(r.line)))
        return d

    # ------------------------------------------------------------------
    # Speichert die letzten Positionsdaten von veränderten Objekten,
    # sofern eine Änderung zwischen dem letzten Aufruf von
    # self.prepare() und dem aktuellen Stand erkannt wurde.
    # Ist bei MouseLeftUp aufzurufen.
    def trackModifications(self):
        if self.last_undo_point is None:
            print("prepare fehlt!")
            return
        d=ds()
        for i, t in enumerate(self.tables):
            if t.pos!=self.last_undo_point.tabs[i].pos:                 # wenn sich die Position der Tabelle verändert hat...
                dt=ds_tab(t, self.last_undo_point.tabs[i].pos)
                d.tabs.append(dt)                                       # ...den vorherigen Stand merken
        for i, r in enumerate(self.relations):
            bs=self.last_undo_point.rels[i].bdr_s
            be=self.last_undo_point.rels[i].bdr_e
            lst=self.last_undo_point.rels[i].pos_lst
            if r.border_start!=bs or r.border_end!=be or r.line!=lst:   # wenn sich etwas an der Relation verändert hat...
                dr=ds_rel(r, bs, be, lst)
                d.rels.append(dr)                                       # ...den vorherigen Stand merken
        if d.hasData():                                                 # wenn es irgendwelche Änderungen gab...
            self.hist.append(d)                                         # ...der Undo-Historie zufügen
        self.last_undo_point=None

    # ------------------------------------------------------------------
    # Macht die letzte Änderung rückgängig.
    def lastModification(self):
        if len(self.hist)==0:
            return
        d=self.hist.pop()
        for e in d.tabs:
            e.obj.pos=e.pos
        for e in d.rels:
            e.obj.border_start=e.bdr_s
            e.obj.border_end=e.bdr_e
            e.obj.line=e.pos_lst
