#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os
import math

FONT_SIZE_BASE=10                                                       # die Default-Schriftgröße
RASTER_BASE=17                                                          # die Größe der initialen Rasterung
RASTER_MIN=3
RASTER_MAX=20
CFGFILE=os.path.join(os.path.expanduser('~'), ".ERMzilla.conf")         # hier werden Settings persistent abgelegt

font_size=FONT_SIZE_BASE                                                # die Schriftgröße in der aktuellen Zoom-Stufe (wird später überschrieben)
raster=RASTER_BASE                                                      # das Raster in der aktuellen Zoom-Stufe

# ----------------------------------------------------------------------
# Richtet point am Raster aus und liefert die neue Koordinate zurück.
# Es wird grundsätzlich aufgerundet.
def pointOnRaster(point):
    return pointOnNewRaster(point, raster)

def pointOnNewRaster(point, new_raster):
    x=numberOnNewRaster(point[0], new_raster)*new_raster
    y=numberOnNewRaster(point[1], new_raster)*new_raster
    return (x, y)

# ----------------------------------------------------------------------
# Liefert zur ganzen Zahl nr deren auf new_raster ausgerichteten Wert.
# Bei new_raster==10 also etwa:
# -29 - -20  ->  -2
# -19 - -10  ->  -1
#  -9 -   0  ->   0
#   1 -  10  ->   1
#  11 -  20  ->   2
#  21 -  30  ->   3
def numberOnNewRaster(nr, new_raster):
    if nr>0:
        rv=int((nr-1)/float(new_raster))+1                              # den float() brauchts bei python3 nicht
    else:
        rv=int(nr/float(new_raster))
    return rv

# ----------------------------------------------------------------------
# Liefert True, wenn color_str das Format "#xxxxxx" einhält - wobei
# "x" einem validen Hex-Zeichen entspricht.
def testColor(color_str):
    if len(color_str)!=7:
        return False
    if color_str[0]!="#":
        return False
    for c in color_str[1:]:
        if c not in "0123456789abcdefABCDEF":
            return False
    return True

# ----------------------------------------------------------------------
# Richtet das übergebene Rectangle so aus, dass der erste Point
# links/oben vom zweiten Point liegt.
def normalizeRectangle(rect):
    (x1, y1), (x2, y2)=rect
    return (min(x1, x2), min(y1, y2)), (max(x1, x2), max(y1, y2))
