#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# Quelle für Grundgerüst:
# http://www.ibm.com/developerworks/linux/tutorials/l-pysocks/#N10518
#
import socket
import select
import random
import hashlib
import time
import datetime

password_ATmega="Passw0rd_M"  # Challenge kommt vom ATmega
password_Python="Passw0rd_P"  # Challenge kommt vom Python-Script

DEBUG=False
#DEBUG=True

fn="/home/dede/daten/Rollotron-Zeiten.txt"

# ###########################################################
# Liefert die Zeiten aus der Zeitentabelle als String mit
# 12*8=96 Zeichen.
def getTimesList():
  with open(fn, 'r') as fl:
    lines=fl.readlines()

  m_str=""
  for ln in lines:
    lns=ln.strip()
    if lns=="" or lns.startswith("//"):
      continue
    lln=lns.replace(":", " ").replace("-", " ").split()
    for i in range(8):
      m_str+=chr(int(lln[i])+ord("0"))
  return(m_str)

# ###########################################################
# Liefert für eine gepackte Zeiten-Liste die entsprechend
# entpackte Version als Liste von 12 Strings.
def formatTimeList(strg):
  frmt=[":", "-", ":", "   ", ":", "-", ":", ""]
  lst=[]
  stro=""
  for i in xrange(len(strg)):
    stro+="%02d"%(ord(strg[i])-ord("0"),)+frmt[i%8]
    if i%8==7:
      lst.append(stro)
      stro=""
  return(lst)

# ###########################################################
# Liefert für zwei gepackte Zeiten-Listen ein Set von
# Integers der Monate mit Änderungen.
def findDifferences(strg1, strg2):
  ret_set=set()
  for i in range(len(strg1)):
    if strg1[i]!=strg2[i]:
      ret_set.add(i//8)
  return(ret_set)

# ###########################################################
# Zeigt für zwei gepackte Zeiten-Listen die Werte für die
# Monate an, in denen die beiden Zeiten-Listen voneinander
# abweichen.
def showDifferences(strgATmega, strgFile, indent=19):
  m=[ "Januar", "Februar", "März", "April", "Mai", "Juni", "Juli",
      "August", "September", "Oktober", "November", "Dezember"  ]
  d=findDifferences(strgATmega, strgFile)
  if d!={}:
    l1=formatTimeList(strgATmega)
    l2=formatTimeList(strgFile)
    for i in d:
      print " "*indent, "-"*25, m[i]
      print " "*indent, l1[i], "  (ATmega)"
      print " "*indent, l2[i], "  (Datei)"



# ###########################################################
# Liefert Datum+Uhrzeit immer als Winter- bzw. Normalzeit.
def getNormTime():
  now=datetime.datetime.now()
  if time.localtime().tm_isdst==1:
    now=now+datetime.timedelta(hours=-1)
  return(now.strftime("%Y.%m.%d %H:%M:%S"))



# ###########################################################
# Liefert True, wenn "checksum" auf "strg" passt.
# Sonst False.
def testChecksum(strg, checksum):
  cs=0
  for c in strg:
    cs+=ord(c)
  if "%0.4x"%cs==checksum:
    return(True)
  return(False)

# ###########################################################
# Liefert die Checksumme zu "strg" als 4-Byte-Hex-String.
def getChecksum(strg):
  cs=0
  for c in strg:
    cs+=ord(c)
  return("%0.4x"%cs)




class SocketServer:
  def __init__(self, port):
    self.port=port;
    self.srvsock=socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    self.srvsock.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
    self.srvsock.bind(("", port))
    self.srvsock.listen(5)
    self.descriptors=[self.srvsock]
    print 'SocketServer started on port %s'%port
    self.indent=len(self.curTime())

  # ###########################################################
  # Hauptschleife des SocketServers.
  # Kann nur einen Client zur Zeit verarbeiten (sonst müsste
  # "state" pro Client verwaltet werden)!
  def run(self):
    state="WAIT"
    timeout=3  # 3 Sekunden ohne Kommunikation führt zu disconnect

    while 1:
      (sread, swrite, sexc)=select.select(self.descriptors, [], [], timeout)

      if sread==[]:                         # Timeout
        if len(self.descriptors)>1:         # wenn Clients verbunden
          for sock in self.descriptors:     # über alle Clients
            if sock!=self.srvsock:          # ohne den Server selbst
              print "Timeout..."
              host, port=sock.getpeername()
              self.close_connection(sock, host, port)
              state="WAIT"
        continue
          
      for sock in sread:
        if sock==self.srvsock:        # neuer Connect
          self.accept_new_connection()
        else:                         # Empfang von verbundenem Client 
          try:
            strg=sock.recv(1024)      # Kommando von Client empfangen
          except:
            strg=""                   # Client bei Fehler rausschmeißen
          host, port=sock.getpeername()

          if strg=='':                # Disconnect des Clients
            self.close_connection(sock, host, port)
            state="WAIT"
          else:                       # Client sendet Daten
            if DEBUG: print "raw:", strg
            checksum=strg[len(strg)-4:]   # die letzten 5 Zeichen sind ","+Checksum in Hex
            strg=strg[:len(strg)-5]
            if testChecksum(strg, checksum):
              if DEBUG: print "\nreceived(good):", strg
              checksum_match=True
            else:
              if DEBUG: print "\nreceived(bad ):", strg
              checksum_match=False

            # in:"AUTH_REQ" -> out:challenge
            if state=="WAIT" and strg=="AUTH_REQ":
              self.rand_number=str(random.randint(100000000, 999999999))
              if DEBUG: print "\nsende challenge"
              self.send_string(self.rand_number)
              state="AUTH_REQ_CHALLENGE_SENT"

            # in:MD5-Hash -> out:"[NOT] AUTHORIZED"
            elif state=="AUTH_REQ_CHALLENGE_SENT":
              self.md5hash=strg
              md5=hashlib.md5(self.rand_number+password_Python).hexdigest()
              if DEBUG: print "my md5 = ", md5
              if md5==self.md5hash:
                state="AUTHORIZED_1"
                self.send_string("AUTHORIZED")
              else:
                self.send_string("NOT AUTHORIZED")
                self.close_connection(sock, host, port)
                state="WAIT"

            # in:challenge -> out:MD5-Hash
            elif state=="AUTHORIZED_1":
              self.rand_number=strg
              md5=hashlib.md5(self.rand_number+password_ATmega).hexdigest()
              self.send_string(md5)
              state="AUTHORIZED_2"

            # in:"[NOT] AUTHORIZED" -> out:"FINE"|"BYE"
            elif state=="AUTHORIZED_2":
              if strg=="AUTHORIZED":
                self.send_string("FINE")
                state="AUTHORIZED"
                print self.curTime(), "Autorisierung abgeschlossen"
              else:
                self.send_string("BYE")
                self.close_connection(sock, host, port)
                state="WAIT"

            # in:"TIME_INFO" -> out:"OK"
            elif state=="AUTHORIZED" and strg=="TIME_INFO":
              state="TIME_INFO"
              self.send_string("OK")

            # in:ATmega-time -> out:"OK"
            elif state=="TIME_INFO":
              state="AUTHORIZED"
              self.send_string("OK")
              print " "*self.indent, "Zeit-Info empfangen:", strg

            # in:"GET_TIME" -> out:Linux-time
            elif state=="AUTHORIZED" and strg=="GET_TIME":
              self.send_string(getNormTime())

            # in:"TIMELIST_INFO" -> out:"OK"
            elif state=="AUTHORIZED" and strg=="TIMELIST_INFO":
              state="TIMELIST_INFO"
              self.send_string("OK")

            # in:ATmega-Zeiten-Liste -> out:"LATEST"|"UPDATE"
            elif state=="TIMELIST_INFO":
              state="AUTHORIZED"
              t_str=getTimesList()
              if t_str==strg:
                self.send_string("LATEST")
                print " "*self.indent, "Zeiten-Tabelle ist aktuell"
              else:
                self.send_string("UPDATE")
                showDifferences(strg, t_str, self.indent)

            # in:"GET_TIMELIST" -> out:Linux-Zeiten-Liste
            elif state=="AUTHORIZED" and strg=="GET_TIMELIST":
              t_str=getTimesList()
              self.send_string(t_str)
              print " "*self.indent, "geänderte Zeiten-Tabelle übermittelt"

            # in:<etwas anderes> -> out:"ECHO:"+empfangener String
            else:
              self.send_string("ECHO:"+strg)
              print " "*self.indent, "unbekannte Anforderung:", strg

  # ###########################################################
  # Sendet "strg" + "," + 4-Byte-Checksum an alle verbundenen
  # Clients (außer sich selbst).
  def send_string(self, strg):
    cs=getChecksum(strg)
    for sock in self.descriptors:
      if sock!=self.srvsock:
        sock.send(strg+","+cs)
    if DEBUG: print "sent:", strg+","+cs

  # ###########################################################
  # Nimmt einen neuen Client an und in die Liste der
  # verbundenen Clients auf.
  def accept_new_connection(self):
    newsock, (remhost, remport)=self.srvsock.accept()
    self.descriptors.append(newsock)
    print self.curTime(), 'Verbindung hergestellt %s:%s'%(remhost, remport)

  # ###########################################################
  # Schließt die Verbindung zum Client gemäß "sock".
  def close_connection(self, sock, host="", port=""):
    sock.close()
    self.descriptors.remove(sock)
    print self.curTime(), 'Verbindung geschlossen %s:%s\n'%(host, port)

  # ###########################################################
  # Liefert die Ortszeit als String.
  def curTime(self):
    return(datetime.datetime.now().strftime("%Y.%m.%d %H:%M:%S"))


if __name__=='__main__':
  myServer=SocketServer(2626)
  myServer.run()
