#ifndef wlan_comm_h
#define wlan_comm_h

#include <ESP8266WiFi.h>
#include "globals.h"

int connectKnownWLAN(void);
int connectWLAN(void);
void disconnectWLAN(void);
int connectSocketServer(char *ipaddr, int portnr);
int connectKnownSocketServer(void);
int isConnectedToSocketServer(void);
void disconnectSocketServer(void);
void sendSocketServer(uint8_t *buf, uint32_t len);
uint32_t receiveSocketServer(uint8_t *buf, uint32_t maxlen, uint32_t timeout_ms);

#endif

