#include "sensor.h"

int sensor_minute_idx;
int sensor_day_idx;

/* -------------------------------------------------------------------
 *  Setzt das Array für eine Minute auf invalide.
 *  Ist nur nach erfolgreichem umkopieren nach sensor_day_g aufzurufen.
 */
void clearSensorData_subMinuteArray(void) {
  int s;
  sensor_minute_idx=0;
  for(s=0; s<14; s++) {
    sensor_minute_g[s].bad=1;
  }
}

/* -------------------------------------------------------------------
 *  Setzt das Array für die Stunde "hour" auf invalide.
 *  Ist nur nach erfolgreichem Senden der Stunde aufzurufen.
 */
void clearSensorDataHour(int hour) {
  for(int m=0; m<60; m++) {
    sensor_day_g[hour].data[m].bad=1;
  }
}

/* -------------------------------------------------------------------
 *  Setzt das Array für einen Tag auf invalide.
 *  Ist nur in setup() aufzurufen.
 */
void clearSensorDataArray(void) {
  sensor_day_idx=0;
  for(int h=0; h<26; h++) {
    sensor_day_g[h].timestamp=0;
    clearSensorDataHour(h);
  }
}

/* -------------------------------------------------------------------
 *  Schreibt einen Satz Sensor-Daten in den Minuten-Speicher.
 */
void storeSensorData_subMinute(int temp_E, int temp_L, int temp_Z, int temp_R, int pump_on) {
  sensor_minute_g[sensor_minute_idx].temp_E=temp_E;
  sensor_minute_g[sensor_minute_idx].temp_L=temp_L;
  sensor_minute_g[sensor_minute_idx].temp_Z=temp_Z;
  sensor_minute_g[sensor_minute_idx].temp_R=temp_R;
  sensor_minute_g[sensor_minute_idx].pump_on=pump_on;
  sensor_minute_g[sensor_minute_idx].bad=0;
  sensor_minute_idx++;
  if(sensor_minute_idx>=14) {
    sensor_minute_idx=0;
  }
}

/* -------------------------------------------------------------------
 *  Überträgt die Mittelwerte aus dem Minuten-Speicher in den
 *  Tages-Speicher an die zur Zeit "t" passende Position.
 */
void storeSensorData(time_t t) {
  int temp_E, temp_L, temp_Z, temp_R, pump_on, i, cnt;
  temp_E=temp_L=temp_Z=temp_R=pump_on=0;
  for(i=cnt=0; i<14; i++) {
    if(sensor_minute_g[i].bad==0) {
      /*Serial.print("i: m=");    Serial.print(i);
      Serial.print("   E=");    Serial.print(sensor_minute_g[i].temp_E/16.0);
      Serial.print("   L=");    Serial.print(sensor_minute_g[i].temp_L/16.0);
      Serial.print("   Z=");    Serial.print(sensor_minute_g[i].temp_Z/16.0);
      Serial.print("   R=");    Serial.print(sensor_minute_g[i].temp_R/16.0);
      Serial.print("   p=");    Serial.print(sensor_minute_g[i].pump_on);
      Serial.println();*/
      temp_E+=sensor_minute_g[i].temp_E;
      temp_L+=sensor_minute_g[i].temp_L;
      temp_Z+=sensor_minute_g[i].temp_Z;
      temp_R+=sensor_minute_g[i].temp_R;
      pump_on+=sensor_minute_g[i].pump_on;
      cnt++;
    }
  }
  /*Serial.print("s: c=");    Serial.print(cnt);
  Serial.print("   E=");    Serial.print(temp_E/16.0);
  Serial.print("   L=");    Serial.print(temp_L/16.0);
  Serial.print("   Z=");    Serial.print(temp_Z/16.0);
  Serial.print("   R=");    Serial.print(temp_R/16.0);
  Serial.print("   p=");    Serial.print(pump_on);
  Serial.println();*/
  
  if(cnt>0) {
    sensor_day_g[sensor_day_idx].data[minute(t)].temp_E=temp_E/cnt;           // 4x Mittelwert bilden
    sensor_day_g[sensor_day_idx].data[minute(t)].temp_L=temp_L/cnt;
    sensor_day_g[sensor_day_idx].data[minute(t)].temp_Z=temp_Z/cnt;
    sensor_day_g[sensor_day_idx].data[minute(t)].temp_R=temp_R/cnt;
    sensor_day_g[sensor_day_idx].data[minute(t)].pump_on=(pump_on*10/cnt)>=5; // =1, wenn häufiger an als aus
    sensor_day_g[sensor_day_idx].data[minute(t)].bad=0;
  } else {
    sensor_day_g[sensor_day_idx].data[minute(t)].bad=1;   // kann nicht schaden....
  }
}

/* -------------------------------------------------------------------
 *  Schaltet zur Daten-Speicherung auf die nächste Stunde um.
 */
void nextSensorHour(time_t t) {
  sensor_day_idx++;
  if(sensor_day_idx>=26) {
    sensor_day_idx=0;
  }
  sensor_day_g[sensor_day_idx].timestamp=t;
}

