#include "rtc_eeprom.h"
#include "globals.h"


/* -------------------------------------------------------------------
 *  Initialisiert den ATmega zum Betrieb des RTC/EEPROM-Moduls.
 */
void RTC_EEPROM_init(void) {
  pinMode(RTC_EEPROM_POWER_PIN, OUTPUT);
  Wire.begin(RTC_EEPROM_SDA_PIN, RTC_EEPROM_SCL_PIN);
  digitalWrite(RTC_EEPROM_POWER_PIN, LOW);  // RTC aus
}

/* -------------------------------------------------------------------
 *  Kleine Helferchen für RTC-Funktionen.
 */
byte dec2bcd(byte val) {  return((val/10*16)+(val%10));  }
byte bcd2dec(byte val) {  return((val/16*10)+(val%16));  }

/* -------------------------------------------------------------------
 *  Liefert Datum und Uhrzeit von der RTC als RTCdata.
 */
time_t getRTC(void) {
  tmElements_t tm;
  time_t t;

  digitalWrite(RTC_EEPROM_POWER_PIN, HIGH); delay(1);
  Wire.beginTransmission(DS3231_ADR);
  Wire.write(0);                        // Register(0) (Seconds)
  Wire.endTransmission();
  Wire.requestFrom(DS3231_ADR, 7);      // 7 Byte holen
  tm.Second=bcd2dec(Wire.read())&0x3F;  // Seconds
  tm.Minute=bcd2dec(Wire.read())&0x3F;  // Minutes
  tm.Hour  =bcd2dec(Wire.read())&0x1F;  // Hours
  Wire.read();                          // Day weglesen
  tm.Day   =bcd2dec(Wire.read())&0x1F;  // Date
  tm.Month =bcd2dec(Wire.read())&0x0F;  // Month
  tm.Year  =bcd2dec(Wire.read())&0x3F;  // Year
  tm.Year  +=2000-1970;
  digitalWrite(RTC_EEPROM_POWER_PIN, LOW);
  t=makeTime(tm);                       // time_t setzen
  return(t);
}

/* -------------------------------------------------------------------
 *  Debug-Print der Zeit "t".
 */
void printRTC(time_t t) {
  Serial.print(year(t)); Serial.print(".");  Serial.print(month(t));   Serial.print(".");  Serial.print(day(t));  Serial.print(" ");
  Serial.print(hour(t)); Serial.print(":");  Serial.print(minute(t));  Serial.print(":");  Serial.print(second(t));
}

/* -------------------------------------------------------------------
 *  Stellt die RTC gemäß Parameter ein.
 */
void setRTC(byte YY, byte MM, byte DD, byte hh, byte mm, byte ss) {
  digitalWrite(RTC_EEPROM_POWER_PIN, HIGH); delay(1);
  Wire.beginTransmission(DS3231_ADR);
  Wire.write(0);
  Wire.write(dec2bcd(ss));
  Wire.write(dec2bcd(mm));
  Wire.write(dec2bcd(hh));
  Wire.write(0);
  Wire.write(dec2bcd(DD));
  Wire.write(dec2bcd(MM));
  Wire.write(dec2bcd(YY));
  Wire.endTransmission();
  digitalWrite(RTC_EEPROM_POWER_PIN, LOW);
}

/* -------------------------------------------------------------------
 * Schreibt einen time_t in die RTC.
 */
void setRTC(time_t tm) {
  setRTC(year(tm)-2000, month(tm), day(tm), hour(tm), minute(tm), second(tm));
}

/* -------------------------------------------------------------------
 * Schreibt einen String mit Datum+Zeit in die RTC.
 * Der String muss folgendes Format haben: YYYY.MM.DD hh:mm:ss
 */
void setRTC(char *datetime_str) {
  // Einzelstrings aus Timestamp bauen
  // 2015.10.20 19:48:08
  // 01234567890123456789
  //     X  X  X  X  X
  *(datetime_str+4)='\0';
  *(datetime_str+7)='\0';
  *(datetime_str+10)='\0';
  *(datetime_str+13)='\0';
  *(datetime_str+16)='\0';
  setRTC(atoi(datetime_str)-2000, atoi(datetime_str+5), atoi(datetime_str+8), 
          atoi(datetime_str+11), atoi(datetime_str+14), atoi(datetime_str+17));
}

