#ifndef globals_h
#define globals_h

#include <stdlib.h>
#include <stdint.h>
#include <Time.h>
#include <Arduino.h>

#define DEBUG                   0

#define DS18B20_DATA_PIN        13
#define RELAIS_PIN              12
#define LED_RT_PIN              0
#define LED_BL_PIN              2
#define RTC_EEPROM_POWER_PIN    14
#define RTC_EEPROM_SDA_PIN      4
#define RTC_EEPROM_SCL_PIN      5

#define MAX_SENSOR_COUNT        4       // maximale Anzahl der DS18B20-Sensoren
#define DS3231_ADR              0x68    // I2C-Adresse der RTC
#define AT24C32_ADR             0x57    // I2C-Adresse des EEPROM (bei A0-A2 offen == Default)
#define EEPROM_SIZE             4096    // Anzahl Byte im EEPROM des ESP8266-12E
#define NUMBER_SYNCTIMES        10      // die Anzahl möglicher Sync-Zeiten

struct SensorData {       // zur Aufnahme eines Messwert-Satzes aller vier Sensoren
  int16_t  temp_E  : 12;     // 12 Bit vom DS18B20 via I2C
  int16_t  temp_L  : 12;     // 12 Bit vom DS18B20 via I2C
  int16_t  temp_Z  : 12;     // 12 Bit vom DS18B20 via I2C
  int16_t  temp_R  : 12;     // 12 Bit vom DS18B20 via I2C
  uint8_t  pump_on : 1;      // auf 1 für "Pumpe unter Strom", auf 0 für "Pumpe aus"
  uint8_t  bad     : 1;      // auf 1 für "Satz ist nicht valide", auf 0 für "Daten legal"
}__attribute__((packed));
// packed  :  sizeof(sensorHour_g):424  424*24= 10.176
// unpacked:  sizeof(sensorHour_g):604  604*24= 14.496


struct SensorHour {           // zur Aufnahme einer vollen Stunde von Sensor-Daten
  time_t       timestamp;     // Start-Zeit (Minute == Start-Index in data[])
  SensorData   data[60];      // ein Messwerte-Paar pro Minute
};

extern int error_g;
extern uint8_t ROMcode_g[MAX_SENSOR_COUNT][8];       // ROM-Codes der DS18B20
extern int sensor_count_g;                           // die Anzahl der Sensor-Paare

extern SensorData sensor_minute_g[14];   // die Messwerte innerhalb einer Minute
extern SensorHour sensor_day_g[26];      // die Messwerte des aktuellen Tages (+2 Stunden WLAN-Ausfall-Backup)

// RAM-Version aus dem EEPROM
extern char ROMindex_g[MAX_SENSOR_COUNT];            // die Sensor-Funktion zu ROMcode_g als Character ('E', 'L', 'Z', 'R', '?')
extern char SSID[3][33];                             // drei WLAN-SSIDs, 33 = 32 Byte SSID + '\0'
extern char SocketServer_adr[2][16];                 // zwei numerische Adressen, 16 = XXX.xxx.xxx.xxx + '\0'
extern uint16_t SocketServer_port[2];                // zwei Port-Nummern
extern unsigned char Sync_time[NUMBER_SYNCTIMES][2]; // bis zu NUMBER_SYNCTIMES Uhrzeiten, zu denen gesync't werden soll, 2 Byte für Stunde, Minute
extern unsigned char Power_on_time_g[7][36];         // sieben Bitmaps mit Pumpen-Einschalt-Zeiten (alle fünf Minuten=12 pro Stunde), 36 = 24[h]*12[bit/h] / 8[bit/byte]
extern signed char Threshold[16];                    // bis zu 16 Temperatur- oder Zeit-Schwellwerte/Deltas

#endif

