#include "globals.h"

int error_g;

uint8_t ROMcode_g[MAX_SENSOR_COUNT][8];       // ROM-Codes der DS18B20
int sensor_count_g;                           // die Anzahl der erkannten Sensor-Paare

SensorData sensor_minute_g[14];   // die Messwerte innerhalb einer Minute
SensorHour sensor_day_g[26];      // die Messwerte des aktuellen Tages

// RAM-Version aus dem EEPROM
char ROMindex_g[MAX_SENSOR_COUNT];            // die Sensor-Funktion zu ROMcode_g als Character ('E', 'L', 'Z', 'R', '?')
// 0:28ff94ba021704c6   E
// 1:28ff9e25031704ab   L
// 2:28ff01d20217042f   Z
// 3:28ff21e87316055a   R

char SSID[3][33];                             // drei WLAN-SSIDs, 33 = 32 Byte SSID + '\0'
char SocketServer_adr[2][16];                 // zwei numerische Adressen, 16 = XXX.xxx.xxx.xxx + '\0'
uint16_t SocketServer_port[2];                // zwei Port-Nummern

unsigned char Sync_time[NUMBER_SYNCTIMES][2]; // bis zu NUMBER_SYNCTIMES Uhrzeiten, zu denen gesync't werden soll, 2 = stunde, minute

unsigned char Power_on_time_g[7][36];         // sieben Bitmaps mit Pumpen-Einschalt-Zeiten (alle fünf Minuten=12 pro Stunde), 36 = 24[h]*12[bit/h] / 8[bit/byte]

signed char Threshold[16];                    // bis zu 16 Temperatur- oder Zeit-Schwellwerte/Deltas



