#include "esp_eeprom.h"


/* -------------------------------------------------------------------
 *  
 */
void esp_eeprom_write(int adr, char *buf, int len) {
  EEPROM.begin(EEPROM_SIZE);
  for(;len>=0; len--) {
    EEPROM.write(adr++, *buf++);
  }
  EEPROM.commit();
  EEPROM.end();
}

/* -------------------------------------------------------------------
 *  
 */
void esp_eeprom_read(int adr, char *buf, int len) {
  EEPROM.begin(EEPROM_SIZE);
  for(;len>=0; len--) {
    *buf++=EEPROM.read(adr++);
  }
  EEPROM.end();
}


/* -------------------------------------------------------------------
 *  Kopiert den Inhalt der Variablen
 *    char ROMindex_g[MAX_SENSOR_COUNT];
 *    char SSID[3][33];
 *    char SocketServer_adr[2][16];
 *    uint16_t SocketServer_port[2];
 *    unsigned char Sync_time[NUMBER_SYNCTIMES][2];
 *    unsigned char Power_on_time_g[7][36];
 *    signed char Threshold[16];
 * samt einer Prüfsumme ins EEPROM des ESP8266-12E.
 * Es wird die Folge-Adresse im EEPROM zurückgeliefert, die hinter
 * den kopierten Daten liegt.
 */
int copyVarsToEEPROM(void) {
  uint16_t checksum;
  int i, j, adr;
  unsigned char *ptr;
  adr=0;        // EEPROM Basis-Adresse
  checksum=0;

  EEPROM.begin(EEPROM_SIZE);
  ptr=(unsigned char*)ROMindex_g;
  for(i=0; i<MAX_SENSOR_COUNT; i++) {           // char ROMindex_g[MAX_SENSOR_COUNT]
    EEPROM.write(adr++, *ptr);
    checksum+=*ptr++;
  }
  ptr=(unsigned char*)SSID;
  for(i=0; i<3; i++) {                          // char SSID[3][33]
    for(j=0; j<33; j++) {
      EEPROM.write(adr++, *ptr);
      checksum+=*ptr++;
    }
  }
  ptr=(unsigned char*)SocketServer_adr;
  for(i=0; i<2; i++) {                          // char SocketServer_adr[2][16]
    for(j=0; j<16; j++) {
      EEPROM.write(adr++, *ptr);
      checksum+=*ptr++;
    }
  }
  ptr=(unsigned char*)SocketServer_port;
  for(i=0; i<2; i++) {                          // uint16_t SocketServer_port[2]
    EEPROM.write(adr++, *ptr);
    checksum+=*ptr++;
    EEPROM.write(adr++, *ptr);
    checksum+=*ptr++;
  }
  ptr=(unsigned char*)Sync_time;
  for(i=0; i<NUMBER_SYNCTIMES; i++) {            // unsigned char Sync_time[NUMBER_SYNCTIMES][2]
    for(j=0; j<2; j++) {
      EEPROM.write(adr++, *ptr);
      checksum+=*ptr++;    }
  }
  ptr=(unsigned char*)Power_on_time_g;
  for(i=0; i<7; i++) {                          // unsigned char Power_on_time_g[7][36]
    for(j=0; j<36; j++) {
      EEPROM.write(adr++, *ptr);
      checksum+=*ptr++;
    }
  }
  ptr=(unsigned char*)Threshold;
  for(i=0; i<16; i++) {                         // signed char Threshold[16]
    EEPROM.write(adr++, *ptr);
    checksum+=*ptr++;
  }
  ptr=(unsigned char*)&checksum;
  EEPROM.write(adr++, *ptr++);
  EEPROM.write(adr++, *ptr++);
  EEPROM.commit();
  EEPROM.end();
  return(adr);
}

/* -------------------------------------------------------------------
 *  Kopiert die mittels copyVarsFromRAM2EEPROM() kopierten Daten
 *  zurück ins RAM.
 *  Liefert true (bzw. 1), wenn die Prüfsumme zu den Daten passt.
 */
int copyVarsFromEEPROM(void) {
  uint16_t checksum, checksum_eeprom;
  int i, j, adr;
  unsigned char *ptr;
  adr=0;        // EEPROM Basis-Adresse
  checksum=0;

  EEPROM.begin(EEPROM_SIZE);
  ptr=(unsigned char*)ROMindex_g;
  for(i=0; i<MAX_SENSOR_COUNT; i++) {           // char ROMindex_g[MAX_SENSOR_COUNT]
    *ptr=EEPROM.read(adr++);
    checksum+=*ptr++;
  }
  ptr=(unsigned char*)SSID;
  for(i=0; i<3; i++) {                          // char SSID[3][33]
    for(j=0; j<33; j++) {
      *ptr=EEPROM.read(adr++);
      checksum+=*ptr++;
    }
  }
  ptr=(unsigned char*)SocketServer_adr;
  for(i=0; i<2; i++) {                          // char SocketServer_adr[2][16]
    for(j=0; j<16; j++) {
      *ptr=EEPROM.read(adr++);
      checksum+=*ptr++;
    }
  }
  ptr=(unsigned char*)SocketServer_port;
  for(i=0; i<2; i++) {                          // uint16_t SocketServer_port[2]
    *ptr=EEPROM.read(adr++);
    checksum+=*ptr++;
    *ptr=EEPROM.read(adr++);
    checksum+=*ptr++;
  }
  ptr=(unsigned char*)Sync_time;
  for(i=0; i<NUMBER_SYNCTIMES; i++) {            // unsigned char Sync_time[NUMBER_SYNCTIMES][2]
    for(j=0; j<2; j++) {
      *ptr=EEPROM.read(adr++);
      checksum+=*ptr++;    }
  }
  ptr=(unsigned char*)Power_on_time_g;
  for(i=0; i<7; i++) {                          // unsigned char Power_on_time_g[7][36]
    for(j=0; j<36; j++) {
      *ptr=EEPROM.read(adr++);
      checksum+=*ptr++;
    }
  }
  ptr=(unsigned char*)Threshold;
  for(i=0; i<16; i++) {                         // signed char Threshold[16]
    *ptr=EEPROM.read(adr++);
    checksum+=*ptr++;
  }
  ptr=(unsigned char*)&checksum_eeprom;
  *ptr++=EEPROM.read(adr++);
  *ptr++=EEPROM.read(adr++);
  EEPROM.end();
  return(checksum_eeprom==checksum);
}

