#include "debug.h"


void print2Digits(int digit) {
  if(digit<10) {
    Serial.print("0");
  }
  Serial.print(digit);
}
void printTimestamp(time_t cur) {
  Serial.print(year(cur)); Serial.print(".");  print2Digits(month(cur));  Serial.print(".");  print2Digits(day(cur));  Serial.print(" ");
  print2Digits(hour(cur)); Serial.print(":");  print2Digits(minute(cur)); Serial.print(":");  print2Digits(second(cur));
  Serial.print("   "); Serial.print(cur);
}


void printHEXDigits(unsigned int number, unsigned int lng_msk) {
  for(; lng_msk>0xf; lng_msk>>=4) {
    if((number&lng_msk)==0) {
      Serial.print("0");
    } else {
      break;
    }
  }
  Serial.print(number, HEX);
}

/* -------------------------------------------------------------------
 *  Quelle: http://stackoverflow.com/a/29865/3588613
 */
void hexdump(void *ptr, int buflen) {
  unsigned char *buf = (unsigned char*)ptr;
  int i, j;
  for (i=0; i<buflen; i+=16) {
    printHEXDigits(i, 0xf000);
    Serial.print("  ");
    for (j=0; j<16; j++) 
      if (i+j < buflen) {
        printHEXDigits(buf[i+j], 0xf0);
        Serial.print(" ");
      } else
        Serial.print("   ");
    Serial.print(" ");
    for (j=0; j<16; j++) 
      if (i+j < buflen)
        Serial.print((char)(isprint(buf[i+j]) ? buf[i+j] : '.'));
    Serial.println();
  }
}


