#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Ein Script zum Schreiben von <wpt>-Sätzen anhand der Inhalte der
# Wardriving-Datenbank.
#
# Detlev Ahlgrimm 07.2016
#
# v1.0    14.07.2016  erste Version

import html
from Database4wd        import Database

DATABASE_FILE="/home/dede/daten/wardriving.sqlite"

# ######################################################################
# 
if __name__ == '__main__':
  db=Database(DATABASE_FILE)

  print('<?xml version="1.0" encoding="UTF-8" standalone="yes" ?>')
  print('<gpx version="1.1" creator="RasPi Tracker" xmlns="http://www.topografix.com/GPX/1/1" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd">')

  aps=db.getAllAPs()
  for lat, lon, bssid, name, chan, crypt, calcpts, first_seen, last_seen in aps:
    print('  <wpt lat="%s" lon="%s"><desc>(%s (%s), chan=%s, crypt=%s, pts=%s)</desc></wpt>'%(lat, lon, html.escape(name), bssid, chan, crypt, calcpts))
    
  print('</gpx>')
