#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Analyse-Script zur Anzeige der zu einem AP-Standort gehörenden
# Messpunkte.
#
# Detlev Ahlgrimm 07.2016
#
# v1.0    14.07.2016  erste Version

import sys
from Database4wd        import Database

DATABASE_FILE="/home/dede/daten/wardriving.sqlite"

# ######################################################################
# 
if __name__ == '__main__':
  db=Database(DATABASE_FILE)

  bssid=sys.argv[1].upper()
  rc=db.getAPloc(bssid)
  if rc is None:
    sys.exit("BSSID nicht gefunden!")
  lat, lon, bssid, calc_points, last_calc=rc

  print('<?xml version="1.0" encoding="UTF-8" standalone="yes" ?>')
  print('<gpx version="1.1" creator="RasPi Tracker" xmlns="http://www.topografix.com/GPX/1/1" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd">')
  print('  <wpt lat="%s" lon="%s"><desc>AP berechnet</desc></wpt>'%(lat, lon))
  
  aps=db.getGPSpoints(bssid)
  for lat, lon, dbm in aps:
    print('  <wpt lat="%s" lon="%s"><desc>%s</desc></wpt>'%(lat, lon, dbm))
  print('</gpx>')
