#!/usr/bin/env python
# -*- coding: utf-8 -*-

import wx
import os, sys


# ###########################################################
# Der Fenster-Rahmen für die Kurven-Settings.
class CurveSettingsFrame(wx.Frame):
  def __init__(self, parent, coldesc, pos=wx.DefaultPosition, size=wx.DefaultSize):
    wx.Frame.__init__(self, None, pos=pos, size=size, title="Kurven-Settings")

    self.parent=parent
    self.coldesc=coldesc
    self.Bind(wx.EVT_CLOSE, self.onClose)
    self.Bind(wx.EVT_CHAR_HOOK, self.onKeyDown)
    self.InitUI()
    self.Show()


  # ###########################################################
  # Bei close die aktuelle Fenster-Position ans Hauptprogramm
  # liefern.
  def onClose(self, event):
    sp=self.GetScreenPosition()
    ss=self.GetSizeTuple()
    self.parent.curveSettingsFeedback.SetValue("close,"+str(sp[0])+","+str(sp[1])+","+str(ss[0])+","+str(ss[1]))
    self.Destroy()


  # ###########################################################
  # Reagiert auf die Tasten "H" und "T" und schaltet alle
  # Helligkeits- bzw. Temperatur-Kurven an/aus.
  def onKeyDown(self, event):
    if event.GetKeyCode() in (ord("H"), ord("h")):
      on_flg=None
      for i in range(len(self.cols)):
        if self.cols[i].GetLabel().startswith("Hell"):
          if on_flg is None:
            on_flg=self.cols[i].GetValue()
          self.cols[i].SetValue(not on_flg)
          self.reportChangeBack(i)
    if event.GetKeyCode() in (ord("T"), ord("t")):
      on_flg=None
      for i in range(len(self.cols)):
        if self.cols[i].GetLabel().startswith("Temp"):
          if on_flg is None:
            on_flg=self.cols[i].GetValue()
          self.cols[i].SetValue(not on_flg)
          self.reportChangeBack(i)
    event.Skip(True)


  # ###########################################################
  # Der eigentliche Fensterinhalt
  def InitUI(self):
    self.panel=wx.Panel(self)

    border=1
    self.cols=list()
    self.colPicker=list()
    for i in range(len(self.coldesc)):
      cn, cd, is_on, c_color=self.coldesc[i]

      cb=wx.CheckBox(self.panel, label=cd)
      cb.SetValue(is_on)
      cb.Bind(wx.EVT_CHECKBOX, self.checkChanged)
      self.cols.append(cb)

      cc=wx.ColourPickerCtrl(self.panel, wx.ID_ANY, c_color)
      cc.Bind(wx.EVT_COLOURPICKER_CHANGED, self.colorChanged)
      self.colPicker.append(cc)
    
    sizer=wx.GridBagSizer(1, 1)
    flag=wx.ALIGN_CENTER_VERTICAL
    for ci in range(len(self.coldesc)):
      sizer.Add(self.cols[ci],      (ci, 0), flag=flag, border=border)
      sizer.Add(self.colPicker[ci], (ci, 1), flag=flag, border=border)

    self.panel.SetFocus()
    self.panel.SetSizer(sizer)
    sizer.Fit(self)


  # ###########################################################
  # Verarbeitet eine Farb-Änderung.
  def colorChanged(self, event):
    for i in range(len(self.colPicker)):
      if self.colPicker[i]==event.GetEventObject():
        curve=self.coldesc[i][0]
        color=self.colPicker[i].GetColour().GetAsString(wx.C2S_HTML_SYNTAX)
        self.parent.curveSettingsFeedback.SetValue("color,%s,%s"%(curve, color))


  # ###########################################################
  # Verarbeitet das An- und Ausschalten von Kurven.
  def checkChanged(self, event):
    for i in range(len(self.cols)):
      if self.cols[i]==event.GetEventObject():
        self.reportChangeBack(i)


  # ###########################################################
  # Meldet den An/Aus-Wert der Kurve "idx" ans Hauptfenster.
  def reportChangeBack(self, idx):
    curve=self.coldesc[idx][0]
    if self.cols[idx].GetValue(): state=1
    else:                         state=0
    self.parent.curveSettingsFeedback.SetValue("on/off,%s,%s"%(curve, state))
