#!/usr/bin/env python
# -*- coding: utf-8 -*-

# ###########################################################
# Eine Datenstruktur für die Eckpunkte eines Rechtecks.
# x1 und y1 liegen innerhalb des Rechtecks, x2 und y2 bereits
# außerhalb.
class Rect():
  def __init__(self, x1=None, y1=None, x2=None, y2=None):
    if type(x1)==tuple:
      x1, y1, x2, y2=x1
    self.x1=min(x1, x2)
    self.y1=min(y1, y2)
    self.x2=max(x1, x2)
    self.y2=max(y1, y2)
    self.width =self.x2-self.x1
    self.height=self.y2-self.y1


  # ###########################################################
  # Zugriff via Index erlauben.
  def __getitem__(self, key):
    if   key==0:  return(self.x1)
    elif key==1:  return(self.y1)
    elif key==2:  return(self.x2)
    elif key==3:  return(self.y2)
    elif key==4:  return(self.width)
    elif key==5:  return(self.height)
    else:         raise IndexError("Index nicht zwischen 0 bis 5")


  # ###########################################################
  # print erlauben.
  def __repr__(self):
    return("(x1=%d, y1=%d, x2=%d, y2=%d, width=%d, height=%d)"%(self.x1, self.y1, self.x2, self.y2, self.width, self.height))


  # ###########################################################
  # Vergleich auf Gleichheit erlauben.
  def __eq__(self, o):
    return(self.x1==o.x1 and self.x2==o.x2 and self.y1==o.y1 and self.y2==o.y2)
