#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sqlite3

from LoggerViewDataTypes  import Rect

# ###########################################################
#
class Database():
  def __init__(self, dbname):
    self.connection=sqlite3.connect(dbname)
    self.cursor=self.connection.cursor()


  # ######################################################################
  # Liefert die Anzahl der Kurven als Integer.
  def getColCount(self):
    self.cursor.execute("SELECT count(*) FROM Location")
    fs=self.cursor.fetchone()
    if fs!=None:
      return(fs[0]*2)   # zwei Werte pro "Location"
    return(-1)


  # ######################################################################
  # Liefert eine Liste aus Tupeln mit Spalten-ID und Spalten-Überschrift.
  # Beispiel:
  # [ ('1T', u'Temperatur:Wohnzimmer (Sofaecke)'), 
  #   ('1H', u'Helligkeit:Wohnzimmer (Sofaecke)'),
  #   ('2T', u'Temperatur:aussen, Wohnzimmerfenster, Nordseite'),
  #   ('2H', u'Helligkeit:aussen, Wohnzimmerfenster, Nordseite') ]
  def getColDescription(self):
    self.cursor.execute("SELECT id, location FROM Location")
    fs=self.cursor.fetchone()
    lst=list()
    while fs!=None:
      if fs[1] is None:
        loc="unzugeordnet"
      else:
        loc=fs[1]
      lst.append((str(fs[0])+"T", "Temperatur:"+loc))
      lst.append((str(fs[0])+"H", "Helligkeit:"+loc))
      fs=self.cursor.fetchone()
    return(lst)


  # ######################################################################
  # Liefert die Anzahl der unterschiedlichen Zeit-Werte als Integer.
  def getRowCount(self):
    self.cursor.execute("SELECT count(*) FROM (SELECT DISTINCT timestamp FROM Dump)")
    fs=self.cursor.fetchone()
    if fs!=None:
      return(fs[0])
    return(-1)


  # ######################################################################
  # Liefert die unterschiedlichen Zeit-Werte als keys eines Dictionaries.
  #def getRowIdentifiers(self, timerange):
  #  self.cursor.execute("SELECT DISTINCT timestamp FROM Dump" \
  #                      " WHERE timestamp BETWEEN ? and ?", timerange)
  #  fs=self.cursor.fetchone()
  #  dic=dict()
  #  while fs!=None:
  #    dic.update({fs[0]:0})
  #    fs=self.cursor.fetchone()
  #  return(dic)


  # ######################################################################
  # Liefert Minimum und Maximum der Zeit-Werte als Tupel.
  def getMinMaxTimestamp(self):
    self.cursor.execute("SELECT min(timestamp), max(timestamp) FROM Dump")
    fs=self.cursor.fetchone()
    return(fs)


  # ######################################################################
  # Liefert ein Dictionary mit einem key pro Skala-Seite.
  # Der value ist der Faktor, der in getData() angewandt wird, um den
  # Messwert ganzzahlig zu machen.
  def getFactors(self):
    return({"T":10, "H":1})


  # ######################################################################
  # Liefert die Minimal- und Maximal-Werte pro Kurve als Dictionary.
  # Der key ist der Name der Kurve, value ist ein Rect().
  # Beispiel:
  # { 1T: (x1=1483622580, y1=199, x2=1484805540, y2=294, width=1182960, height=95 )
  #   2T: (x1=1483622580, y1=-91, x2=1484805540, y2=129, width=1182960, height=220)
  #   1H: (x1=1483622580, y1=0,   x2=1484805540, y2=794, width=1182960, height=794)
  #   2H: (x1=1483622580, y1=0,   x2=1484805540, y2=984, width=1182960, height=984) }
  def getDataBoundaries(self):
    fakt=self.getFactors()
    self.cursor.execute("SELECT id, location FROM Location")
    fs=self.cursor.fetchone()
    lst=list()
    while fs!=None:
      lst.append(fs[0])
      fs=self.cursor.fetchone()
    rd=dict()
    for l in lst:
      self.cursor.execute("SELECT min(timestamp), min(temperature), min(light)," \
                          " max(timestamp), max(temperature), max(light)" \
                          " FROM Dump WHERE location=?", (l,))
      fs=self.cursor.fetchone()
      rd.update({str(l)+"T":Rect(fs[0], fs[1]*fakt["T"], fs[3], fs[4]*fakt["T"])})
      rd.update({str(l)+"H":Rect(fs[0], fs[2]*fakt["H"], fs[3], fs[5]*fakt["H"])})
    return(rd)


  # ######################################################################
  # Liefert ein Dictionary mit dem Timestamp als key und einer Liste aus
  # Tupeln als value. Die Liste enthält alle Spalten, die Werte zum
  # Timestamp key enthalten. Jedes Tupel enthält zuerst den Spaltenkenner
  # und danach den Messwert als Integer.
  # Beispiel:
  #   { 1483784160: [('1T', 209), ('1H', 269), ('2T', 2), ('2H', 915)],
  #     1483674960: [('1T', 231), ('1H', 0), ('2T', -86), ('2H', 0)]    }
  def getData(self, timerange):
    fakt=self.getFactors()
    self.cursor.execute("SELECT timestamp, location, temperature, light" \
                        " FROM Dump WHERE timestamp BETWEEN ? and ?", timerange)
    fs=self.cursor.fetchone()
    dic=dict()
    while fs!=None:
      n=str(fs[1])
      n1=n+"T"
      n2=n+"H"
      apnd=[(n1, int(fs[2]*fakt["T"])), (n2, int(fs[3]*fakt["H"]))]
      if fs[0] in dic:
        dic.update({fs[0]:dic[fs[0]]+apnd})
      else:
        dic.update({fs[0]:apnd})
      fs=self.cursor.fetchone()
    return(dic)
