#!/usr/bin/env python
# -*- coding: utf-8 -*-

import wx

from LoggerViewDataTypes  import Rect


# ###########################################################
#
class Area():
  def __init__(self, win):
    self.win=win

  # ###########################################################
  # Stellt den DeviceContext ein.
  def setDC(self, dc):
    self.dc=dc
    width, height=self.dc.GetTextExtent("So 00:00:00")
    self.min_grid_width=width+3     # Skalen-Minimal-Abstand X-Achse
    self.min_grid_height=height+20  # Skalen-Minimal-Abstand Y-Achse

  # ###########################################################
  # Ändert die Ränder innerhalb des Fensters.
  def setBorders(self, n, s, w, e):
    self.borderN=n
    self.borderS=s
    self.borderW=w
    self.borderE=e

  # ###########################################################
  # Berechnet Abmessung und Position des Darstellungsbereiches
  # sowie Skala-Parameter neu - abhängig von der Fenster-Größe.
  def recalculate(self, minutes):
    # der sichtbare Bereich liegt auf:
    #   horizontal  0 bis self.screen_width-1
    #   vertikal    0 bis self.screen_height-1
    # die Höhe der StatusBar muss in "borderS" berücksichtigt werden
    self.screen_width, self.screen_height=self.win.GetSize()

    # 0,0 liegt (gedacht) links-unten
    self.boundaries=Rect(self.borderW, self.borderS, self.screen_width-self.borderE, self.screen_height-self.borderN)
    
    self.pixel_per_minute=self.boundaries.width/float(minutes)                                            # float
    self.minutes_per_step=self.roundUp(max(1, minutes/float(self.boundaries.width/self.min_grid_width)))  # int

    self.gridX_pix_per_step=self.minutes_per_step*self.pixel_per_minute                                   # float
    self.gridX_cnt=int(1+self.boundaries.width/self.gridX_pix_per_step)                                   # int
    if (self.gridX_cnt*self.gridX_pix_per_step)>self.boundaries.width:
      self.gridX_cnt-=1

    self.gridY_cnt=max(2, min(20, self.boundaries.height/self.min_grid_height))                           # int
    self.gridY_pix_per_step=float(self.boundaries.height-1)/self.gridY_cnt                                # float

  # ###########################################################
  # Liefert "val" als aufgerundeten int (ohne "import math").
  def roundUp(self, val):
    if val>int(val):
      return(int(val)+1)
    return(int(val))
