#include "wlan_comm.h"

WiFiClient sockSrv_client;

/* -------------------------------------------------------------------
 *  Stellt eine Verbindung zum WLAN her und liefert True, wenn es
 *  geklappt hat.
 */
int connectWLAN(void) {
  int retries;

  WiFi.forceSleepWake();
  WiFi.begin("FreifunkWees01.2 (http://ffw)", "");
  retries=20;
  while(WiFi.status()!=WL_CONNECTED && retries>0) { // 10 Sek. lang probieren
    delay(500);
    retries--;
  }
  return(WiFi.status()==WL_CONNECTED);
}

/* -------------------------------------------------------------------
 *  Trennt die Verbindung zum WLAN.
 */
void disconnectWLAN(void) {
  WiFi.disconnect();
  delay(100);   // dem disconnect etwas Zeit geben, bevor abgeschatet wird
  WiFi.forceSleepBegin();
}

/* -------------------------------------------------------------------
 *  Stellt eine Verbindung zum SocketServer her und liefert True,
 *  wenn es geklappt hat.
 */
int connectSocketServer(void) {
  return(sockSrv_client.connect("192.168.42.80", 2627));  // ss=.80, ffw=.99
}

/* -------------------------------------------------------------------
 *  Trennt die Verbindung zum SocketServer.
 */
void disconnectSocketServer(void) {
  sockSrv_client.stop();
}

/* -------------------------------------------------------------------
 *  Liefert eine 16 Bit lange Prüfsumme für den Speicherbereich ab
 *  "buf" in der Länge "len".
 */
uint16_t getBinChecksum(uint8_t *buf, uint16_t len) {
  uint16_t cs=0;
  for(; len>0; len--)  {
    cs+=*buf++;
  }
  return(cs);
}

/* -------------------------------------------------------------------
 *  Sendet den Inhalt des Speicherbereiches ab "buf" in der Länge
 *  "len" samt einer Prüfsumme an den SocketServer.
 *  Die Verbindung zum SocketServer muss offen sein.
 */
void sendSocketServer(uint8_t *buf, uint32_t len) {
  uint8_t *buf_ptr;
  uint16_t cs=getBinChecksum(buf, len);

  buf_ptr=(uint8_t *)malloc(len+2);
  if(buf_ptr!=NULL) {
    memcpy(buf_ptr, buf, len);
    *(buf_ptr+len)=cs&0xff;
    *(buf_ptr+len+1)=(cs>>8)&0xff;
    sockSrv_client.write((const uint8_t *)buf_ptr, len+2);
    free(buf_ptr);
  }
}

/* -------------------------------------------------------------------
 *  Empfängt bis zu "maxlen" Byte vom SocketServer und legt sie ab
 *  "buf" im Speicher ab. Passt die Checksum gemäß der letzten zwei
 *  Byte zu den davor liegenden Byte, wird die Länge der empfangenen
 *  Daten (ohne die letzten zwei Byte für die Checksum)
 *  zurückgeliefert. Ansonsten wird 0 geliefert.
 *  Die Verbindung zum SocketServer muss offen sein.
 */
uint32_t receiveSocketServer(uint8_t *buf, uint32_t maxlen, uint32_t timeout_ms=2000) {
  uint32_t start_ms=millis();
  uint32_t idx, len;
  uint16_t cs;

  while(sockSrv_client.available()==0 && (millis()-start_ms)<timeout_ms) {
    delay(10);
  }
  idx=0;
  while(sockSrv_client.available()>0 && idx<maxlen && (millis()-start_ms)<timeout_ms) {
    buf[idx++]=sockSrv_client.read();
  }
  if(idx>=3 && (millis()-start_ms)<timeout_ms) {
    // Mindestens ein Byte Nutzdaten empfangen und kein Timeout aufgetreten
    len=idx-2;
    cs=getBinChecksum(buf, len);
    if(buf[len]==(uint8_t)cs&0xff && buf[len+1]==(uint8_t)(cs>>8)&0xff) {
      buf[len]='\0';  // String draus machen...falls es einer sein sollte
      return(len);
    }
  }
  return(0);
}

