#include "sensors.h"

/* -------------------------------------------------------------------
 *  Fragt die beiden Sensoren ab und liefert die Messwerte in einer
 *  Variable vom Typ SensorData.
 */
SensorData readSensors(void) {
  static SensorData sd;
  static int16_t tmp;

  tmp=readDS18B20_CRC();
  if(tmp!=0x8FFF) {
    sd.temp=tmp;
    tmp=1023-analogRead(17);   // Fix für vertauschten Anschluß des LDR
    tmp-=LDR_FIX;
    if(tmp<0) { sd.ldr=0; } else { sd.ldr=tmp; }
    sd.bad=0;
  } else {
    sd.temp=0;
    sd.ldr=0;
    sd.bad=1;
  }
  return(sd);
}


/* -------------------------------------------------------------------
 *  Liefert die Mittelwerte der gesammelten Sensor-Daten aus 
 *  "sensorMinute_g" als SensorData.
 */
SensorData getSensorMinuteAvg(void) {
  static SensorData sd;
  int i, good_cnt;
  int32_t temp, ldr;

  for(temp=ldr=0, good_cnt=i=0; i<sensorMinute_idx_g; i++) {
    if(sensorMinute_g[i].bad==0) {
      temp+=sensorMinute_g[i].temp;
      ldr+= sensorMinute_g[i].ldr;
      good_cnt++;
    }
  }
  if(good_cnt>0) {
    sd.temp=temp/good_cnt;
    sd.ldr= ldr/good_cnt;
    sd.bad=0;
  } else {
    sd.temp=0;
    sd.ldr=0;
    sd.bad=1;
  }
  return(sd);
}

