#ifndef globals_h
#define globals_h

#include <stdlib.h>
#include <stdint.h>
#include <Time.h>

#define DEBUG   0

#define ALIVE_LED_PIN 2
#define SPECIAL_SYNC_BUTTON_PIN 14
#define DS18B20_DATA_PIN 13

#define LDR_FIX 68  // gelieferter Wert vom ADC bei Dunkelheit

struct SensorData {       // zur Aufnahme eines Datums von einem Sensor-Paar (3 Byte)
  int16_t  temp : 12;     // 12 Bit vom DS18B20 via I2C
  uint16_t ldr  : 10;     // 10 Bit vom GL5528 via analogRead()
  uint8_t  bad  : 1;      // auf 1 für "temp-CRC hat nicht gepasst", auf 0 für "Daten legal"
} __attribute__((packed));


struct RTCdata {
  uint32_t year   : 6; // funktioniert bis 2063, danach ;-) statt 2000 einfach 2064 addieren
  uint32_t month  : 4;
  uint32_t day    : 5;
  uint32_t hour   : 5;
  uint32_t minute : 6;
  uint32_t second : 6;
};


struct SensorHour {           // zur Aufnahme einer vollen Stunde von Sensor-Daten
  RTCdata      timestamp;     // Start-Zeit (Minute == Start-Index in data[])
  SensorData   data[60];      // ein Messwerte-Paar pro Minute
  uint16_t     checksum;      // Checksum für das EEPROM
};
#define SIZEOF_SensorHour 186 // alternativ müsste SensorHour auch als "packed" deklariert werden

extern uint8_t ROMcode_g[8];           // ROM-Code des DS18B20

extern SensorData sensorMinute_g[12];  // hier landen die Sensor-Daten einer Minute
extern int sensorMinute_idx_g;         // der Index dafür

extern SensorHour sensorHour_g;        // die Messwerte der aktuellen Stunde

extern SensorHour sensorDay_g[24];     // die Messwerte eines Tages

extern uint8_t warnings_g;             // sammelt Warnings zur Übermittlung ans Python-Script

extern time_t power_on_timestamp_g;    // wird in setup() nach dem ersten GET_TIME gesetzt

extern int done_second_g;        // diese Sekunde wurde bereits bearbeitet
extern int cur_minute_g;         // diese Minute wird gerade bearbeitet
extern int cur_hour_g;           // diese Stunde wird gerade bearbeitet
extern int done_day_g;           // dieser Tag wurde bereits bearbeitet
extern int done_sync_minute_g;   // in dieser Minute wurde schon synchronisiert
extern int done_sync_day_g;      // wird nur bei Sync-Fehler auf den Tag des fehlgeschlagenen Sync's gesetzt

void init_sensorMinute(void);
void init_sensorHour(void);
void init_sensorDay(void);
RTCdata buildTimestamp(time_t ts);
void stringToTime(uint8_t *datetime_str);
uint16_t getSensorHourChecksum(uint8_t *ptr);

#endif

