#include "globals.h"

uint8_t ROMcode_g[8];           // ROM-Code des DS18B20

SensorData sensorMinute_g[12];  // hier landen die Sensor-Daten einer Minute
int sensorMinute_idx_g;         // der Index dafür

SensorHour sensorHour_g;        // die Messwerte der aktuellen Stunde

SensorHour sensorDay_g[24];     // die Messwerte eines Tages

uint8_t warnings_g;             // sammelt Warnings zur Übermittlung ans Python-Script
// Bit 0 : Schaltung hat neu gestartet
// Bit 1 : Der Sonder-Sync-Taster wurde zusammen mit dem Reset-Taster gedrückt -> Python-Script soll neue Standort-Sätze anlegen

time_t power_on_timestamp_g;

int done_second_g;        // diese Sekunde wurde bereits bearbeitet
int cur_minute_g;         // diese Minute wird gerade bearbeitet
int cur_hour_g;           // diese Stunde wird gerade bearbeitet
int done_day_g;           // dieser Tag wurde bereits bearbeitet
int done_sync_minute_g;   // in dieser Minute wurde schon synchronisiert
int done_sync_day_g;      // wird nur bei Sync-Fehler auf den Tag des fehlgeschlagenen Sync's gesetzt

/* -------------------------------------------------------------------
 *  Liefert einen ungültigen RTCdata zurück.
 */
RTCdata badRTCdata(void) {
  static RTCdata d;
  d.year=0;
  d.month=0;
  d.day=0;
  d.hour=0;
  d.minute=0;
  d.second=0;
  return(d);
}

/* -------------------------------------------------------------------
 *  Liefert einen ungültigen SensorData zurück.
 */
SensorData badSensorData(void) {
  static SensorData d;
  d.temp=0;
  d.ldr=0;
  d.bad=1;
  return(d);
}

/* -------------------------------------------------------------------
 *  Setzt alle Elemente von "sensorMinute_g" auf ungültig.
 */
void init_sensorMinute(void) {
  for(int i=0; i<12; i++) {
    sensorMinute_g[i]=badSensorData();
  }
}

/* -------------------------------------------------------------------
 *  Setzt alle Elemente von "sensorHour_g" auf ungültig.
 */
void init_sensorHour(void) {
  sensorHour_g.timestamp=badRTCdata();
  for(int i=0; i<60; i++) {
    sensorHour_g.data[i]=badSensorData();
  }
}

/* -------------------------------------------------------------------
 *  Setzt alle Elemente von "sensorDay_g" auf ungültig.
 */
void init_sensorDay(void) {
  for(int i=0; i<24; i++) {
    sensorDay_g[i].timestamp=badRTCdata();
    for(int j=0; j<60; j++) {
      sensorDay_g[i].data[j]=badSensorData();
    }
  }
}

/* -------------------------------------------------------------------
 *  Liefert zu einem time_t-Timestamp die entsprechende Version
 *  als RTCdata.
 */
RTCdata buildTimestamp(time_t ts) {
  RTCdata t;

  t.second=second(ts)&0x3F;
  t.minute=minute(ts)&0x3F;
  t.hour  =hour(ts)&0x1F;
  t.day   =day(ts)&0x1F;
  t.month =month(ts)&0x0F;
  t.year  =(year(ts)-2000)&0x3F;
  return(t);
}

/* -------------------------------------------------------------------
 *  Setzt die interne Uhr gemäß des Timestamp-Strings "datetime_str".
 */
void stringToTime(uint8_t *datetime_str) {
  // Einzelstrings aus Timestamp bauen
  // 2015.10.20 19:48:08
  // 01234567890123456789
  //     X  X  X  X  X
  *(datetime_str+4)='\0';
  *(datetime_str+7)='\0';
  *(datetime_str+10)='\0';
  *(datetime_str+13)='\0';
  *(datetime_str+16)='\0';
  setTime(atoi((char*)datetime_str+11), atoi((char*)datetime_str+14), atoi((char*)datetime_str+17),
          atoi((char*)datetime_str+8), atoi((char*)datetime_str+5), atoi((char*)datetime_str));
}

/* -------------------------------------------------------------------
 *  Liefert die Checksum für eine SensorHour von den Elementen
 *  "ptr.timestamp" und "ptr.data[60]".
 */
uint16_t getSensorHourChecksum(uint8_t *ptr) {
  uint16_t cs;
  cs=0;
  for(int i=0; i<184; i++) {   // über 1xRTCdata + 60xSensorData
    cs+=*ptr++;
    cs++;
  }
  return(cs);
}

