#include "ds18b20.h"

OneWire ds18b20(DS18B20_DATA_PIN);

/* -------------------------------------------------------------------
 *  Ermittelt die Seriennummern des DS18B20 und legt sie in 
 *  "ROMcode_g[]" ab.
 */
uint8_t discoverOneWireDevices(void) {
  ds18b20.search(ROMcode_g);
  if(OneWire::crc8(ROMcode_g, 7)!=ROMcode_g[7]) {
    return(0);
  }
  ds18b20.reset_search();
  return(1);
}

/* -------------------------------------------------------------------
 *  Liefert den Temperaturwert [°C] des DS18B20 mit der Seriennummer
 *  gemäß "ROMcode_g" als Integer.
 *  Die unteren vier Bit sind Nachkommastellen - also durch 16.0
 *  teilen, um die Temperatur mit Nachkommastellen zu erhalten.
 *  Der Rückgabewert 0x8FFF kennzeichnet einen illegalen
 *  Temperaturwert (bei dem die CRC nicht gepasst hat).
 */
int16_t readDS18B20_CRC(void) {
  static uint8_t scratchpad[9];
  static int j;

  for(int i=0; i<3; i++) {  // maximal 3 Versuche, einen Wert mit korrekter CRC zu lesen
    ds18b20.reset();
    ds18b20.select(ROMcode_g);
    ds18b20.write(0x44);  // This command initiates a single temperature conversion
    ds18b20.reset();
    ds18b20.select(ROMcode_g);
    ds18b20.write(0xBE);  // Read Scratchpad
    for(j=0; j<9; j++) {
      scratchpad[j]=ds18b20.read();
    }
    if(scratchpad[5]==0xFF && scratchpad[7]==0x10 && OneWire::crc8(scratchpad, 8)==scratchpad[8]) {
      // Was für ein beschissener CRC. Wenn man die Verbindung zur DQ-Leitung zieht, kommt 9x 0x00 zurück.
      // Und 9x 0x00 führt zu OneWire::crc8()==0 - passt also zu scratchpad[8] und ist damit
      // in diesem Fall vollkommen wertlos.
      // Daher werden zusätzlich die Byte 5 und 7 geprüft, die laut Doku "Reserved" und ab Werk
      // mit den Werten 0xFF bzw. 0x10 vorbelegt sind.
     
      // Für Byte 0 und 1 gilt:     
      // BIT    15 14 1  1  11 10  09  08  07  06  05  04   03   02   01   00
      //        S  S  S  S  S  2^6 2^5 2^4 2^3 2^2 2^1 2^0 2^-1 2^-2 2^-3 2^-4
      return((scratchpad[1]<<8)|scratchpad[0]);
    }
  }
  return(0x8FFF); // Fehlerkennung (0x8FFF kann nicht als Temperatur-Wert vorkommen)
}
